<?php
/**
 * Admin PRT Model for Blue Hour Calculator
 *
 * @package     prt.com_prt
 * @subpackage  Components
 * @link        http://www.winkelewski.de
 * @license		GNU/GPL, some parts of this based on JS code by  Arnold Barmettler, www.astronomie.info / www.CalSky.com
 * @created     01.04.2010
 *
 *              based on algorithms by Peter Duffett-Smith's great and easy book 'Practical Astronomy with your Calculator'.
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

if(!@class_exists('topcmmRequestRemote') )
{
    require_once( 'request_remote.php' );
}

jimport( 'joomla.application.component.model' );

/**
 * Admin PRT Model
 *
 * @package    prt.com_prt
 * @subpackage Components
 */
class ChatModelSettings extends JModel
{
	/**
	 * PRT data array
	 *
	 * @var array
	 */
	var $_data;
	var $_valid;
	var $post;

    function store()
    {
    	$data = get_object_vars($this->getData());
		$post = JRequest::get('post');
		$data['server'] = $post['server'];
		switch($post['server'])
		{
            case 0:
			    $post['server_host'] = str_ireplace('http://', '', $post['server_host']);
	            $data['server_host'] = ($post['server_host'] != '127.0.0.1' && $post['server_host'] != 'localhost') ? $post['server_host'] : $_SERVER['HTTP_HOST'];
	            $data['server_port'] = $post['server_port'] ? $post['server_port'] : 51127;
	            $data['http_port'] = $post['http_port'] ? $post['http_port'] : 35555;
	            $data['api_url'] = 'http://' . $data['server_host'] . ':' . $data['http_port'] . '/';
	            $client_location = $post['client_loc'] ? ($post['client_loc'] . (substr($post['client_loc'],-1,1) != '/' ? '/' : '')) : '';
	            if ($client_location == '')
	            {
	            	$data['client_location'] = $data['api_url'];
	            }
	            else
	            {
	                $data['client_location'] = $client_location;
	            }

				$sub_loc = substr($data['client_location'], 0 ,7);
	            if($sub_loc != "http://")
	            {
	            	$data['client_location'] = "http://".$data['client_location'];
	            }

	            $s_own_loc = 1;
	            $c_own_loc = 1;
	            $da = 1;

	            if ($post['server_local'])
	            {
	                // $s_own_loc = $this->validate_server($data['server_host'], $data['server_port']);

	               	$c_own_loc = $this->validate_client($data['client_location']);

	                if ($c_own_loc != 1)
	                {
	                	$da = $this->validate_data_api($data['api_url'] . 'online.js');
	                }
	                /* if ($s_own_loc)
	                {
	                    $this->setError('Chat Server host or port is configured incorrectly');
	                    $this->_valid = 1;
			            return false;
	                } */
	                if ($c_own_loc)
	                {
	                    $this->setError('Chat Server http_port or Client location is configured incorrectly');
	                    $this->_valid = 1;
			            return false;
	                }
	                if ($da)
	                {
	                    $this->setError('Chat Server http_port is configured incorrectly');
	                    $this->_valid = 1;
			            return false;
	                }
	                $this->_valid = 0;
                }
                else
                {
	                $c_own_loc = $this->validate_client($data['client_location']);

	                if ($c_own_loc == 0)
	                {
	                	$this->_valid = 0;
	                }
	                else
	                {
	                    $this->setError('Chat client location is configured incorrectly');
	                    $this->_valid = 1;
			            return false;
	                }
                }
	            $data['client'] = $post['client'];
	            break;
	        case 1:

	            $data['client_location'] = $post['client_loc'] ? ($post['client_loc'] . (substr($post['client_loc'],-1,1) != '/' ? '/' : '')) : '';
				$data['api_url'] = 'http://' . parse_url($data['client_location'], PHP_URL_HOST) . '/';
				$data['group'] = substr(parse_url($data['client_location'], PHP_URL_PATH),1,-1);
				$data['client'] = $post['client'];

				$sub_loc = substr($data['client_location'], 0 ,7);
	            if($sub_loc != "http://")
	            {
	            	$data['client_location'] = "http://".$data['client_location'];
	            }

				$c_own_loc = 1;
				$loc = 1;
				$da = 1;
	            if ($content = topcmmRequestRemote::requestRemote($data['client_location']))
	            {
	            	if ($urlinfo = $this->getHostParameters($data['client_location']))
					{
						$loc = 0;
					}
					if ($loc == 0)
					{
						$c_own_loc = $this->validate_client($data['client_location']);
					}
					if ($c_own_loc == 0)
					{
	            		$da = $this->validate_data_api($data['api_url'] . 'online.js?group=' . $data['group']);
					}
					if ($da == 1)
					{
	                	$this->setError('Client Location is configured incorrectly');
			        	return false;
					}
	            }
	            else
	            {
	            	$this->setError('Client Location is configured incorrectly');
	            	return false;
	            }
	            break;
	        case 2:
	            $data['room'] = $post['room'] ? $post['room'] : $_SERVER['HTTP_HOST'];
	            break;
		}

		$data['present_mode'] = $post['present_mode'];
		$data['full_screen'] = $post['full_screen'];
		$data['chat_status'] = $post['chat_status'];
		$data['room_list'] = $post['room_list'];
		$data['user_list'] = $post['user_list'];
        $data['client_width'] = is_numeric($post['client_width']) ? $post['client_width'] : 700;
        $data['client_height'] = is_numeric($post['client_height']) ? $post['client_height'] : 528;
        if($post['server'] == 2)
        {
	        $data['client_width'] = is_numeric($post['client_width']) ? $post['client_width'] : 700;
	        $data['client_height'] = is_numeric($post['client_height']) ? $post['client_height'] : 528;
	        if($data['client_width'] < 728)
	        {
	        	$data['client_width'] = 728;
	        }
        }
        else 
        {
        	 $data['client_width'] = is_numeric($post['client_width']) ? $post['client_width'] : 700;
       		 $data['client_height'] = is_numeric($post['client_height']) ? $post['client_height'] : 528;
        }
	    $data['client_lang'] = $post['client_lang'];
        $data['client_skin'] = $post['client_skin'];

        $data['id'] = 1;

        //xin jia de
        $data['sty'] = $post['sty'];
        $data['show_live'] = $post['show_live'];
        $data['own_width'] = $post['own_width'] ? $post['own_width'] : 495;
        $data['own_height'] = $post['own_height'] ? $post['own_height'] : 250;
        $data['liveurl'] = $post['liveurl'];
        $data['liveroom'] = $post['liveroom'];
        $data['dis_profile'] = $post['dis_profile'];


        $config =& $this->getTable();
		// Bind the form fields to the hello table
		if (!$config->bind($data))
		{
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Make sure the hello record is valid
		if (!$config->check())
		{
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Store the web link table to the database
		if (!$config->store())
		{
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		return true;
    }
    /**
	* Check 123 FlashChat Server Config
	* @parm $host   Chat Server Host
	* @parm $port   Chat Server Port
	* @return integer config status
	*/
/*     function validate_server($host, $port)
    {
    	$s_own_loc = 1;
        $apiCommand = '<Init/>';
        $resultDoc = "";
		if(ini_get("allow_url_fopen"))
		{
			$fp = @fsockopen($host, $port, $errno, $errstr, 2);
			if($fp)
			{
				fputs($fp,$apiCommand."\0");
				while (!feof($fp))
				{
					$resultDoc .= fgets($fp, 1024);
					$resultDoc = rtrim($resultDoc);
				}
				$parser = xml_parser_create("UTF-8");
				xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
				xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
				if (xml_parse_into_struct($parser, $resultDoc, $values, $tags))
				{
					if($values)
					{
						$s_own_loc = 0;
					}
					xml_parser_free($parser);
					fclose($fp);
				}
			}
		}else{
        $s_own_loc = 0;
		}
        return $s_own_loc;
    } */

    /**
	* Check 123 FlashChat Data api
	* @parm $data_api   Chat Data Api
	* @return integer config status
	*/
    function validate_data_api($data_api)
    {
		$da = 1;
        if(substr(topcmmRequestRemote::requestRemote($data_api,0), 9, 3) == 200)
        {
        	$da = 0;
    	}
        return $da;
    }

    /**
	* Check 123 FlashChat Client Location
	* @parm $client_loc   Chat Client Location
	* @return integer config status
	*/
    function validate_client($client_loc)
    {
		$c_own_loc = 1;
		$swf = $client_loc . '123flashchat.swf';
    	if($headers = topcmmRequestRemote::requestRemote($swf,0))
		{
        $c_own_loc = (substr($headers, 9, 3) == '200') ? 0 : 1;
		}
        return $c_own_loc;
    }

	function getHostParameters($client_location)
	{
		$content = topcmmRequestRemote::requestRemote($client_location);
		if(!empty($content))
		{
			$pattern = '|var urlValue="(.*)"|U';
			preg_match($pattern, $content, $matches);
			if(!empty($matches[1]))
			{
				$url = $matches[1];
				$urlinfo = parse_url($url);
				return $urlinfo;
			}
			else
			{
				$pattern = '|PARAM NAME=movie VALUE="(.*)"|U';
				preg_match($pattern, $content, $matches);
				if(!empty($matches[1]))
				{
					$url = $matches[1];
					$urlinfo = parse_url($url);
					return $urlinfo;
				}
			}
			return false;
		}
	}

	function _buildQuery()
	{
		$query = ' SELECT * ' . ' FROM #__chat_config ';
		return $query;
	}

	function getData()
	{
		// Lets load the data if it doesn't already exist
		if (empty( $this->_data ))
		{
			$query = $this->_buildQuery();
			/*$this->_data = $this->_getList( $query );*/
			$this->_db->setQuery( $query );
			$this->_data = $this->_db->loadObject();
		}
		return $this->_data;
	}

	function getValid()
	{
		$cfg = get_object_vars($this->getData());

		if ($cfg['server_host'] == '127.0.0.1' || $cfg['server_host'] == 'localhost')
		{
			$cfg['server_host'] = $_SERVER['HTTP_HOST'];
		}
		if ($cfg['client_location'] == '')
		{
			$cfg['client_location'] = 'http://' . $cfg['server_host'] . ':' . $cfg['http_port'] . '/';
		}
		if($this->validate_client($cfg['client_location']) or $this->validate_client("http://127.0.0.1:35555/") ){
			$this->_valid = "1";
		};


		return $this->_valid;
	}
}