<?php
/**
 * @version		$Id: view.html.php 14401 2010-01-26 14:10:00Z louis $
 * @package		Joomla
 * @subpackage	Weblinks
 * @copyright	Copyright (C) 2005 - 2010 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.view');

/**
 * HTML View class for the WebLinks component
 *
 * @static
 * @package		Joomla
 * @subpackage	Weblinks
 * @since 1.0
 */
class ChatViewAdminpanel extends JView
{
	function display($tpl = null)
	{
		JToolBarHelper::title( '123 Flash Chat: <small><small>[ Admin Panel ]</small></small>' );

		$user =& JFactory::getUser();
		$cfg = & $this->get('Data');
		
		if ($cfg->server == 0)
		{
			if ($cfg->client_location != '')
			{
				$client_location = $cfg->client_location;
			}
			else
			{
				if ($cfg->server_host == '127.0.0.1' || $cfg->server_host == 'localhost')
				{
					$server_host = $_SERVER['HTTP_HOST'];
				}
				else
				{
					$server_host = $cfg->server_host;
				}
				$client_location = 'http://' . $server_host . '/';
			}
			$server_host = $cfg->server_host;
	        $server_port = $cfg->server_port;
		}
		else
		{
			$client_location = $cfg->client_location;
			
			$server_host = parse_url($cfg->client_location, PHP_URL_HOST);

			if ($urlinfo = $this -> getHostParameters($cfg->client_location))
	    	{
	       		parse_str($urlinfo['query']);
	       		if (isset($init_host))
	       		{
	       			$server_host = $init_host;
	       		}
	        	$server_port = $init_port;
	    	}
		}
		if(empty($server_port))
		{
			$server_port = "35555";
		}

		$url = $client_location . "admin_123flashchat.swf?init_host=" . $server_host . "&init_port=" . $server_port . "&init_user=" . rawurlencode(htmlspecialchars_decode($user->username)) . "&init_password=" . $user->password . (($cfg->server == 1) ? ("&init_group=" . $cfg->group) : "");
		
		$this->assign('server', $cfg->server);
		$this->assign('url', $url);

		parent::display($tpl);
	}
	
	function getHostParameters($client_location)
	{
		$content = @file_get_contents($client_location);
		if(!empty($content))
		{
			$pattern = '|var urlValue="(.*)"|U';
			preg_match($pattern, $content, $matches);
			if(!empty($matches[1]))
			{
				$url = $matches[1];
				$urlinfo = parse_url($url);
				return $urlinfo;
			}
			else
			{
				$pattern = '|PARAM NAME=movie VALUE="(.*)"|U';
				preg_match($pattern, $content, $matches);
				if(!empty($matches[1]))
				{
					$url = $matches[1];
					$urlinfo = parse_url($url);
					return $urlinfo;
				}
			}
			return false;
		}
	}
}
