<?php
/**
 * @version		$Id: view.html.php 14401 2010-01-26 14:10:00Z louis $
 * @package		Joomla
 * @subpackage	Weblinks
 * @copyright	Copyright (C) 2005 - 2010 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.view');
//require_once(JPATH_SITE.DS.'components'.DS.'com_community'.DS.'libraries'.DS.'core.php');
//require_once(JPATH_SITE.DS.'components'.DS.'com_community'.DS.'views'.DS.'views.php');

/**
 * HTML View class for the WebLinks component
 *
 * @static
 * @package		Joomla
 * @subpackage	Weblinks
 * @since 1.0
 */
if(!@class_exists('topcmmRequestRemote') )
{
    require_once( 'request_remote.php' );
}
class ChatViewChat extends JView
{
	function getChatUrl($cfg)
	{
		switch($cfg->server)
		{
			case 0:

				if ($cfg->server_host == '127.0.0.1' || $cfg->server_host == 'localhost')
				{
					$server_host = $_SERVER['HTTP_HOST'];
				}
				else
				{
					$server_host = $cfg->server_host;
				}
				if ($cfg->client_location != '')
				{
					$temp = $cfg->client_location;
				}
				else
				{
					$temp = 'http://' . $server_host . '/';
				}

				$clientname = $cfg->client ? (($cfg->client == 1) ? 'htmlchat/123flashchat.html' : 'avatarchat.swf') : '123flashchat.swf';
				$url =  $temp . $clientname . "?init_host=" . $cfg->server_host . "&init_port=" . $cfg->server_port ;
				//$url .= $cfg->client ? "" : ("&init_skin=" . $cfg->client_skin);
				$url .= ($cfg->server == 1) ? ("&init_group=" . $cfg->group) : "";
				return $url;
				break;

			case 1:
				$server_port = 35555;
				$server_host = parse_url($cfg->client_location, PHP_URL_HOST);
				if ($urlinfo = $this->getHostParameters($cfg->client_location))
	            {
	            	parse_str($urlinfo['query']);
	            	$server_host = $init_host;
	            	$server_port = $init_port;
	            }

				$content = topcmmRequestRemote::requestRemote($cfg->client_location,1);
				$clientname = $cfg->client ? (($cfg->client == 1) ? 'htmlchat/123flashchat.html' : 'avatarchat.swf') : '123flashchat.swf';
				$url = $cfg->client_location . $clientname . "?init_host=" . $server_host . "&init_port=" . $server_port;
				//$url .= $cfg->client ? "" : ("&init_skin=" . $cfg->client_skin);
				$url .= ($cfg->server == 1) ? ("&init_group=" . $cfg->group) : "";
				return $url;
				break;

			case 2:
				if ($cfg->room == '')
				{
					$cfg->room = $_SERVER['HTTP_HOST'];
				}
				$url = "http://free.123flashchat.com/js.php?room=" . urlencode($cfg->room) . "&skin="  . $cfg->client_skin . "&lang="  . $cfg->client_lang;
				return $url;
				break;
		}
	}

	function getHostParameters($client_location)
	{
		$content = topcmmRequestRemote::requestRemote($client_location,1);
		if(!empty($content))
		{
			$pattern = '|var urlValue="(.*)"|U';
			preg_match($pattern, $content, $matches);
			if(!empty($matches[1]))
			{
				$url = $matches[1];
				$urlinfo = parse_url($url);
				return $urlinfo;
			}
			else
			{
				$pattern = '|PARAM NAME=movie VALUE="(.*)"|U';
				preg_match($pattern, $content, $matches);
				if(!empty($matches[1]))
				{
					$url = $matches[1];
					$urlinfo = parse_url($url);
					return $urlinfo;
				}
			}
			return false;
		}
	}

	function display($tpl = null)
	{
		//$fcConfig = &JComponentHelper::getParams( 'com_chat' );
		$user		=& JFactory::getUser();
		$cfg		=& $this->get('Config');
	/*	if ($cfg->server == 0)
		{
			$client_name = $cfg->client ? (($cfg->client == 1) ? 'htmlchat/123flashchat.html' : 'avatarchat.swf') : '123flashchat.swf';
			$chaturl = $cfg->client_location . $client_name . "?init_host=" . $cfg->server_host . "&init_port=" . $cfg->server_port . "&init_lang=" . $cfg->client_lang;
			$chaturl .= $cfg->client ? "" : ("&init_skin=" . $cfg->client_skin);
			$chaturl .= ($cfg->server == 1) ? ("&init_group=" . $cfg->group) : "";
		}
		elseif ($cfg->server == 1)
		{
			$content = @file_get_contents($cfg->client_location);
			$client_name = $cfg->client ? (($cfg->client == 1) ? 'htmlchat/123flashchat.html' : 'avatarchat.swf') : '123flashchat.swf';
			$chaturl = $cfg->client_location . $client_name . "?init_host=" . $cfg->server_host . "&init_port=" . $cfg->server_port . "&init_lang=" . $cfg->client_lang;
			$chaturl .= $cfg->client ? "" : ("&init_skin=" . $cfg->client_skin);
			$chaturl .= ($cfg->server == 1) ? ("&init_group=" . $cfg->group) : "";
		}
		else
		{
			$chaturl = "http://free.123flashchat.com/js.php?room=" . $cfg->room . "&skin="  . $cfg->client_skin . "&lang="  . $cfg->client_lang;
		}
	*/
		$chaturl = $this->getChatUrl($cfg);
		if ($user->id)
		{
			if ($cfg->server == 2)
			{
				$chaturl .= "&user=" . rawurlencode(htmlspecialchars_decode($user->username));
			}
			else
			{
				$chaturl .= "&init_user=" . rawurlencode(htmlspecialchars_decode($user->username)) . "&init_password=" . $user->password;
			}
		}
		if ($room = JRequest::getVar('room'))
		{
			$chaturl .= "&init_room=" . $room;
		}
        $this->assign('server', $cfg->server);
        $this->assign('client', $cfg->client);
        $server_self = $_SERVER['PHP_SELF'];

		if ($cfg->full_screen==1)
		{
			$width = '100%';
			$height = '100%';
		}
		else
		{
			$width = $cfg->client_width . 'px';
			$height = $cfg->client_height . 'px';
		}
		$chaturl .= "&init_nickname=".rawurlencode(htmlspecialchars_decode($user->name));
        $this->assign('width', $width);
        $this->assign('height', $height);
		$this->assign('chaturl', $chaturl);
		$this->assign("present_mode", $cfg->present_mode);
		parent::display($tpl);
	}
}
