<?php
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
*/
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport('joomla.application.component.model');

class CommunityModelFriendList extends JCCModel
{
    private static $STRANGER = "stranger";
    private static $GENERAL = "general";
    var $_friendListGeneral;
    var $_friendListStranger;
    function __construct()
    {
        parent::__construct();
        $this->_friends = CFactory::getModel('friends');
    }


    public function setFriendListGeneral()
    {
        if($this->_user)
        {
            $this->_friendListGeneral = $this->_friends->getFriends($this->_user->id);
//            echo $this->_user->id;
//            exit;
        }
        return $this->_friendListGeneral;
    }

    public function setFriendListStranger()
    {
        if($this->_user)
        {
            //$this->_friendListGeneral = $this->_friends->getFriends($this->_user->id);
            $this->_friendListStranger = "";
        }
        return $this->_friendListStranger;
    }

    public function setUser($username)
    {
        if(!empty($username))
        {
            $this->_user = CFactory::getUser($username);
        }
    }
    public function addFriend($destUsername = "")
    {
        if(!$this->checkPermission() || empty($destUsername))
        {
            return false;
        }
        $destUser = CFactory::getUser($destUsername);
        if($destUser)
        {
            if($this->_user->id == $destUser->id)
            {
                return false;
            }
            $this->_friends->addFriend($this->_user->id, $destUser->id, "", 1);
            $this->_friends->addFriend($destUser->id, $this->_user->id, "", 1);
            $this->_friends->updateFriendCount($this->_user->id);
            $this->_friends->updateFriendCount($destUser->id);
        }
        return false;
    }

    public function removeFriend($destUsername = "")
    {
        if(!$this->checkPermission() || empty($destUsername))
        {
            return false;
        }

        $destUser = CFactory::getUser($destUsername);
        //echo $destUsername;
        if($destUser)
        {
            $this->_friends->deleteFriend($this->_user->id, $destUser->id);
        }
    }

    private function checkPermission()
    {
        if(empty ($this->_user))
        {
            return false;
        }
        return true;
    }
    public function getFriendListXML()
    {
        $this->setXML();
        if($this->_user)
        {
            if(!$this->_friendListGeneral)
            {
                $this->setFriendListGeneral();
            }
            if(!$this->_friendListStranger)
            {
                $this->setFriendListStranger();
            }
        }
        if($this->_friendListGeneral || $this->_friendListStranger)
        {

            if($this->_friendListGeneral)
            {
                $this->setUserListElement(self::$GENERAL, $this->_friendListGeneral);
            }
            if($this->_friendListStranger)
            {
                $this->setUserListElement(self::$STRANGER, $this->_friendListStranger);
            }
            $this->doc->appendChild($this->UD);
        }
        $this->doc->appendChild($this->UD);
        return $this->doc->saveXml();
    }

    private function setUserListElement($type, $data)
    {
        $general = $this->doc->createElement("g");
        $general->setAttribute("n", $type);
        foreach ($data as $val)
        {
            $u = $this->doc->createElement("u");
            $u->setAttribute("n", $val->username);
            $general->appendChild($u);
        }
        $this->FL->appendChild($general);
        $this->UD->appendChild($this->FL);
    }
    private function setXML()
    {
        if(!empty($this->doc)){
            unset ($this->doc);
        }
        $this->doc = new DOMDocument('1.0', 'utf-8');
        $this->FL = $this->doc->createElement('FL');
        $this->UD = $this->doc->createElement('UD');
    }

}
?>
