<?php
/**
 * @package Module 123 Flash Chat for Joomla! 3.0
 * @version $Id: settings.php  2013-02-1$
 * @author Cheney
 * @copyright (C) 2001-2013 - TOPCMM SOFTWARE
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @websites http://www.123flashchat.com
 * @technical support http://www.123flashchat.com/support.html
**/
// Check to ensure this file is included in Joomla!
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

if(!@class_exists('topcmmRequestRemote') )
{
    require_once( 'request_remote.php' );
}

jimport( 'joomla.application.component.model' );

class FlashchatModelSettings extends JModelList
{

	var $_data;
	var $_valid;
	var $post;

    function store(){
    	$data = get_object_vars($this->getData());
		$post = JRequest::get('post');
		$data['fc_extendserver'] = $post['extendserver'];
		$data['fc_servertype'] = ($post['servertype'] > 0) ? 1 : 0;
		switch($post['extendserver']){
            case 0:
            	$client_location = $post['client_loc'];
            	if($client_location){
            		$data['fc_client_loc'] = $client_location . (substr($client_location,-1,1) != '/' ? '/' : '');
            		$serverinfo = $this->getServerHostPortLocal($data['fc_client_loc']);
            		$data['fc_server_host'] = !empty($post['server_host']) ? $post['server_host'] : (empty($serverinfo['fc_server_host']) ? $_SERVER['HTTP_HOST'] : $serverinfo['fc_server_host']) ;
            		$data['fc_server_host_s'] = empty($serverinfo['fc_server_host_s']) ? $data['fc_server_host'] : $serverinfo['fc_server_host_s'];
            		$data['fc_server_host_h'] = empty($serverinfo['fc_server_host_h']) ? $data['fc_server_host'] : $serverinfo['fc_server_host_h'];
            		if(!is_numeric($post['server_port']) || strpos($post['server_port'] ,".")!==false){
            			$data['fc_server_port'] = empty($serverinfo['fc_server_port']) ? ( $data['fc_servertype'] == 1 ? '51212' : '51127') : $serverinfo['fc_server_port'] ;
            		}else{
            			$data['fc_server_port'] = $post['server_port'];
            		}
            		if(!is_numeric($post['server_port_h']) || strpos($post['server_port_h'] ,".")!==false){
            			$data['fc_server_port_h'] = empty($serverinfo['fc_server_port_h']) ? ( $data['fc_servertype'] == 1 ? '31212' : '35555') : $serverinfo['fc_server_port_h'] ;
            		}else{
            			$data['fc_server_port_h'] = $post['server_port_h'];
            		}
            		$data['fc_server_port_s'] = empty($serverinfo['fc_server_port_s']) ? ( $data['fc_servertype'] == 1 ? '51213' : '51128') : $serverinfo['fc_server_port_s'] ;
            		$data['fc_api_url'] = 'http://' . $data['fc_server_host'] . ':' . $data['fc_server_port_h'] . '/';
            	}else{
            		$data['fc_server_host'] = $_SERVER['HTTP_HOST'];
            		$data['fc_server_host_h'] = $data['fc_server_host_s'] = $data['fc_server_host'];
            		if($data['fc_servertype'] == 1){
            			$data['fc_server_port_h'] = '31212';
            			$data['fc_server_port_s'] = '51213';
            			$data['fc_server_port'] = '51212';
            		}else{
            			$data['fc_server_port_h'] = '35555';
            			$data['fc_server_port_s'] = '51128';
            			$data['fc_server_port'] = '51127';
            		}
            		$data['fc_api_url'] = 'http://' . $data['fc_server_host'] . ':' . $data['fc_server_port_h'] . '/';
            		$data['fc_client_loc'] = $data['fc_api_url'];
            	}
            	$s_own_loc = 1;
	            $c_own_loc = 1;
	            $da = 1;
	            if($post['server_loc']){
	            	$c_own_loc = $this->validate_client($data['fc_client_loc']);
            		$da = $this->validate_data_api($data['fc_api_url'] . 'online.js');
		            if($c_own_loc || $da){
	            		//$this->setError('Chat Server http_port or Client location is configured incorrectly');
	            		JLog::add('Chat Server http_port or Client location is configured incorrectly!', JLog::ERROR, 'jerror');
	                    $this->_valid = 1;
			            return false;
	            	}
	            	$this->_valid = 0;
	            }else{
	            	$c_own_loc = $this->validate_client($data['fc_client_loc']);
	            	if($c_own_loc){
	            		//$this->setError('Chat Server http_port or Client location is configured incorrectly');
	            		JLog::add('Chat Server http_port or Client location is configured incorrectly!', JLog::ERROR, 'jerror');
	                    $this->_valid = 1;
			            return false;
	            	}else{
	            		$this->_valid = 0;
	            	}
	            }
            	$check = $this->validate_client('http://'.parse_url($data['fc_client_loc'], PHP_URL_HOST).':'.$data['fc_server_port_h'].'/');
            	if($check){
            		//$this->setError('Client Location is configured incorrectly');
            		JLog::add('Client Location is configured incorrectly!', JLog::ERROR, 'jerror');
            		$this->_valid = 1;
			        return false;
            	}
	            break;
	        case 1:
	            $data['fc_client_loc'] = $post['client_loc'] ? ($post['client_loc'] . (substr($post['client_loc'],-1,1) != '/' ? '/' : '')) : '';
	            if(empty($data['fc_client_loc'])){
	            	//$this->setError('Client Location is Empty!');
	            	JLog::add('Client Location is Empty!', JLog::ERROR, 'jerror');
	            	return false;
	            }				
				$serverinfo = $this->getServerHostPortHost($data['fc_client_loc']);
				if($serverinfo){					
					$data['fc_server_host'] = empty($serverinfo['fc_server_host']) ? parse_url($data['fc_client_loc'], PHP_URL_HOST) : $serverinfo['fc_server_host'];
					$data['fc_server_host_s'] = empty($serverinfo['fc_server_host_s']) ? '' : $serverinfo['fc_server_host_s'];
					$data['fc_server_host_h'] = empty($serverinfo['fc_server_host_h']) ? '' : $serverinfo['fc_server_host_h'];
					$data['fc_server_port'] = empty($serverinfo['fc_server_port']) ? '' : $serverinfo['fc_server_port'];
					$data['fc_server_port_h'] = empty($serverinfo['fc_server_port_h']) ? '' : $serverinfo['fc_server_port_h'];
            		$data['fc_server_port_s'] = empty($serverinfo['fc_server_port_s']) ? '' : $serverinfo['fc_server_port_s'];
            		$data['fc_api_url'] = 'http://' . $data['fc_server_host'] . '/';
            		$data['fc_group'] = substr(parse_url($data['fc_client_loc'], PHP_URL_PATH),1,-1);
					$c_own_loc = $this->validate_client($data['fc_client_loc']);
					$da = $this->validate_data_api($data['fc_api_url'] . 'online.js?group=' . $data['fc_group']);
			        if($c_own_loc || $da){
			        	//$this->setError('Client Location is configured incorrectly!');
			        	JLog::add('Client Location is configured incorrectly!', JLog::ERROR, 'jerror');
			        	return false;
			        }
				}else{
					//$this->setError('Client Location is configured incorrectly');
					JLog::add('Client Location is configured incorrectly!', JLog::ERROR, 'jerror');
	            	return false;
				}
	            break;
	        case 2:
	            $room = $post['room'];
	            if($room != ""){
					preg_match("/\w+$/", $room,$matches);
					if(strlen($room) != strlen($matches[0])){
					
						JLog::add('Chat Room can only use numbers,letters and underline!', JLog::ERROR, 'jerror');
						return false;
					}
					$data['fc_room'] = $room;
				}else{
					$data['fc_room'] = 'Lobby';
				}
	            break;
		}
		
    	if($data['fc_servertype'] == 1){
	        $data['fc_clienttype'] = 0;
	    }else{
	        $data['fc_clienttype'] = ($post['clienttype'] > 0) ? 1 : 0;
	    }
		$data['fc_fullscreen'] = ($post['fullscreen'] > 0) ? 1 : 0;
		$data['fc_room_list'] = $post['room_list'];
		$data['fc_user_list'] = $post['user_list'];
		
		$data['fc_client_width'] = ($post['client_width'] && is_numeric($post['client_width']) && $post['client_width'] >=700) ? $post['client_width'] : 700;
		$data['fc_client_height'] = ($post['client_height'] && is_numeric($post['client_height']) && $post['client_height'] >=642) ? $post['client_height'] : 642;
		
		
	    $data['fc_client_lang'] = $post['client_lang'];
        $data['fc_client_skin'] = $post['client_skin'];	
        $data['id'] = 1;
        $config = $this->getTable();
		// Bind the form fields to the hello table
		if (!$config->bind($data)){
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Make sure the hello record is valid
		if (!$config->check()){
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Store the web link table to the database
		if (!$config->store()){
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		return true;
    }
 
    /**
	* Check 123 FlashChat Data api
	* @parm $data_api   Chat Data Api
	* @return integer config status
	*/
    function validate_data_api($data_api){
		$da = 1;
        if(substr(topcmmRequestRemote::requestRemote($data_api,0), 9, 3) == 200){
        	$da = 0;
    	}
        return $da;
    }

    /**
	* Check 123 FlashChat Client Location
	* @parm $client_loc   Chat Client Location
	* @return integer config status
	*/
    function validate_client($client_loc){
		$c_own_loc = 1;
		$swf = $client_loc . 'admin_123flashchat.swf';
    	if($headers = topcmmRequestRemote::requestRemote($swf,0)){
        	$c_own_loc = (substr($headers, 9, 3) == '200') ? 0 : 1;
		}
        return $c_own_loc;
    }

    function _buildQuery(){
		$query = ' SELECT * FROM #__123flashchat ';
		return $query;
	}

	function getData(){
		// Lets load the data if it doesn't already exist
		if (empty( $this->_data )){
			$query = $this->_buildQuery();
			/*$this->_data = $this->_getList( $query );*/
			$this->_db->setQuery( $query );
			$this->_data = $this->_db->loadObject();
		}
		return $this->_data;
	}
	
	/*public function getServerPort($server_host){
		$server_port = '';
		if($server_host == ''){
			$server_host = $_SERVER['SERVER_NAME'];
		}
		if($headers = topcmmRequestRemote::requestRemote('http://'.$server_host.':35555/admin_123flashchat.swf',0)){
        	if(substr($headers, 9, 3) == '200'){
        		$server_port = '35555';
        		return $server_port;
        	}
		}
		if($headers = topcmmRequestRemote::requestRemote('http://'.$server_host.':31212/admin_123flashchat.swf',0)){
        	if(substr($headers, 9, 3) == '200'){
        		$server_port = '31212';
        		return $server_port;
        	}
		}
		return $server_port;
	}*/
	
	function getValid($fcSetting){
		$c_server_loc = 1;
		if($fcSetting->fc_server_host){
			if($fcSetting->fc_server_host == $_SERVER['SERVER_NAME']){
				$c_own_loc = $this->validate_client('http://'.$fcSetting->fc_server_host.':'.$fcSetting->fc_server_port_h.'/');
				if(!$c_own_loc){
					$c_server_loc = 0;
				}
			}
		}else{
			$c_own_loc = $this->validate_client('http://'.$_SERVER['SERVER_NAME'].':'.$fcSetting->fc_server_port_h.'/');
			if(!$c_own_loc){
				$c_server_loc = 0;
			}
		}
		return $c_server_loc;
	}
	
	function getServerHostPortLocal($client_location){
		$content = topcmmRequestRemote::requestRemote($client_location.'htmlchat/config/config.js',1);
		if ($content){
			//server host
		 	preg_match('/init_host = "([a-zA-Z0-9.]*)";/', $content, $matches);
	        if(isset($matches[1])){
	        	$data['fc_server_host'] = $matches[1];			        	
	        }else{
		        preg_match('/init_host="([a-zA-Z0-9.]*)";/', $content, $matches);
		        if(isset($matches[1])){
		        	$data['fc_server_host'] = $matches[1];			        	
		        }else{
		        	$data['fc_server_host'] = '';
		        }
	        }
	        //server port
	        preg_match('/init_port = ([0-9]*);/', $content, $matches);
	        if(isset($matches[1])){
	        	$data['fc_server_port'] = $matches[1];			        	
	        }else{
	        	$data['fc_server_port'] = '';
	        }
	        //server host s
			preg_match('/init_host_s = "([a-zA-Z0-9.]*)";/', $content, $matches);
	        if(isset($matches[1])){
	        	$data['fc_server_host_s'] = $matches[1];			        	
	        }else{
		        preg_match('/init_host_s="([a-zA-Z0-9.]*)";/', $content, $matches);
		        if(isset($matches[1])){
		        	$data['fc_server_host_s'] = $matches[1];			        	
		        }else{
		        	$data['fc_server_host_s'] = '';
		        }
	        }
	        //server port s
	        preg_match('/init_port_s = ([0-9]*);/', $content, $matches);
	        if(isset($matches[1])){
	        	$data['fc_server_port_s'] = $matches[1];			        	
	        }else{
	        	$data['fc_server_port_s'] = '';
	        }
	        //server host h
			preg_match('/init_host_h = "([a-zA-Z0-9.]*)";/', $content, $matches);
	        if(isset($matches[1])){
	        	$data['fc_server_host_h'] = $matches[1];			        	
	        }else{
		        preg_match('/init_host_h="([a-zA-Z0-9.]*)";/', $content, $matches);
		        if(isset($matches[1])){
		        	$data['fc_server_host_h'] = $matches[1];			        	
		        }else{
		        	$data['fc_server_host_h'] = '';
		        }
	        }
	        //server port h
	        preg_match('/init_port_h = ([0-9]*);/', $content, $matches);
	        if(isset($matches[1])){
	        	$data['fc_server_port_h'] = $matches[1];			        	
	        }else{
	        	$data['fc_server_port_h'] = '';
	        }
	        return $data;
	    }else{
	    	return false;
	    }
	}

	function getServerHostPortHost($client_location){
		$content = topcmmRequestRemote::requestRemote($client_location,1);
		if ($content){
			//server port
			preg_match('/init_port=([0-9]*)/', $content, $matches);
	        if(isset($matches[1])){
	        	$data['fc_server_port'] = $matches[1];			        	
	        }
	        //server port s
			preg_match('/init_port_s=([0-9]*)/', $content, $matches);
	        if(isset($matches[1])){
	        	$data['fc_server_port_s'] = $matches[1];			        	
	        }
	        //server port h
			preg_match('/init_port_h=([0-9]*)/', $content, $matches);
	        if(isset($matches[1])){
	        	$data['fc_server_port_h'] = $matches[1];			        	
	        }
	        //server host
			preg_match('/init_host=([a-zA-Z0-9.]*)/', $content, $matches);
	        if(isset($matches[1])){
	        	$data['fc_server_host'] = $matches[1];			        	
	        }
	        //server host s
			preg_match('/init_host_s=([a-zA-Z0-9.]*)&/', $content, $matches);
	        if(isset($matches[1])){
	        	$data['fc_server_host_s'] = $matches[1];			        	
	        }
	        //server host h
			preg_match('/init_host_h=([a-zA-Z0-9.]*)&/', $content, $matches);
	        if(isset($matches[1])){
	        	$data['fc_server_host_h'] = $matches[1];			        	
	        }
	        return $data;
	    }else{
            return false;
	    }
	}
}