<?php
/**
 * @package Module 123 Flash Chat for Joomla! 3.0
 * @version $Id: helper.php  2013-02-1$
 * @author Cheney
 * @copyright (C) 2001-2013 - TOPCMM SOFTWARE
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @websites http://www.123flashchat.com
 * @technical support http://www.123flashchat.com/support.html
**/
// Check to ensure this file is included in Joomla!
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

if(!@class_exists('topcmmRequestRemote') ){
	require_once( 'request_remote.php' );
}
class modFlashchatHelper{

	public function getConfig(){
        $db	= JFactory::getDBO();
		$query = ' SELECT * FROM #__123flashchat ';
		$db->setQuery( $query );
		return $db->loadObject();
	}
	public function getStatus(){
        $cfg = self::getConfig();
        $data = topcmmRequestRemote::requestRemote(CACHE_PATH."status.js",1);
	    $status_json = substr($data,10);
	    if ((time() > substr($data,0,10)) || !$status_json){
	        $server =  $cfg->fc_extendserver;
	        switch ($server){
	            case 0:
	        	    $status_js = $cfg->fc_api_url . "online.js";
	        	    if($rs = topcmmRequestRemote::requestRemote($status_js, 1)){
	        	        $status_json = substr($rs,11,-1);
	        	    }
	        	    break;
	        	case 1:
	        	    $status_js = $cfg->fc_api_url . "online.js?group=" . $cfg->fc_group;
	        	    if($rs = topcmmRequestRemote::requestRemote($status_js,1)){
	        	        $status_json = substr($rs,11,-1);
	        	    }
	        	    break;
	        	case 2:
	        	    $status_js = "http://free.123flashchat.com/freeroomnum.php?roomname=" . $cfg->fc_room;
	        	    if($rs = topcmmRequestRemote::requestRemote($status_js,1)){
                        preg_match("/document.write\('(.*)'\);/",$rs,$matches);
	        	        $status['ln'] = $matches[1];					
	        	        $status['rn'] = '';
	        	        $status['cn'] = '';
	        	        $status_json = json_encode($status);
	        	    }
	        	    break;
	        }
			@file_put_contents(CACHE_PATH."status.js",(time() + 120) . $status_json);
	    }
		return json_decode($status_json,true);
	}
	
	
	public function getRooms(){
		$opts = array('http'=>array('timeout'=>3,));
		$context = stream_context_create($opts); 
        $cfg = self::getConfig();
        $data = topcmmRequestRemote::requestRemote(CACHE_PATH."rooms.js",1);
		$rooms_json = substr($data,10);
	    if ((time() > substr($data,0,10)) || !$rooms_json){
	    	$server =  $cfg->fc_extendserver;
	        switch ($server) {
	            case 0:
	        	    $room_js = $cfg->fc_api_url . "rooms.js";
	        	    break;
	            case 1:
	        	    $room_js = $cfg->fc_api_url . "rooms.js?group=" . $cfg->fc_group;
	        	    break;
	            case 2:
	            	break;
	        }
	        if($rs = topcmmRequestRemote::requestRemote($room_js, 1)){
	        	$rooms_json = substr($rs,10,-1);
	        }
	        @file_put_contents(CACHE_PATH."rooms.js",(time() + 120) . $rooms_json);
	    }
	    return json_decode($rooms_json, true);
	}
	
	
	public function getUsers(){
		$opts = array('http'=>array('timeout'=>2,));
		$context = stream_context_create($opts); 
        $cfg = self::getConfig();
		$data =  topcmmRequestRemote::requestRemote(CACHE_PATH."users.js",1);
		$users_json = substr($data,10);
	    if ((time() > substr($data,0,10)) || !$users_json){
	    	$server =  $cfg->fc_extendserver;
	        switch ($server){
	            case 0:
	                $rooms = self::getRooms();
	                if ($rooms == null){
	                	return null;
	                }
	                $users = array();
	                foreach ($rooms as $room){
	                    $user_js = $cfg->fc_api_url . "roomonlineusers.js?roomid=" . $room['id'];
	                    if($rs = topcmmRequestRemote::requestRemote($user_js, 1)){
	                        $users = array_merge($users, json_decode(substr($rs,20,-1),true));
	                    }
	                }
	                $users_json = json_encode($users);
	        	    break;
	            case 1:
	        	    $user_js = $cfg->fc_api_url . "roomonlineusers.js?group=" . $cfg->fc_group;
	        	    if($rs = topcmmRequestRemote::requestRemote($user_js, 1)){
	        	        $users_json = substr($rs,20,-1);
	        	    }
	        	    break;
	        	case 2:
	        		$users = array();       		
	        	    $user_js = "http://free.123flashchat.com/freeroomuser.php?roomname=" . $cfg->fc_room;
	        	    if($rs = topcmmRequestRemote::requestRemote($user_js, 1)){
                        preg_match("/document.write\('(.*)'\);/",$rs,$matches);
	    	            foreach (explode(',', $matches[1]) as $user){
	    	                $users[] = array('name' => $user);
	    	            }
	    	        }
	    	        $users_json = json_encode($users);
	    	        break;
	        }
	        $users_json = self::filterUserList($users_json);
	        @file_put_contents(CACHE_PATH."users.js",(time() + 120) . $users_json);
	    }
	    return json_decode($users_json, true);
	}
	
	private function filterUserList($users_json){
		$user_array =  json_decode($users_json,true);
		$user_regroup_array = array();
		$user_tmp_array = array();
		foreach($user_array as $key => $val){
			if (!in_array($val['name'], $user_tmp_array)){
				$user_tmp_array[] = $val['name'];
				$user_regroup_array[$key] = $user_array[$key];
			}
		}
		return json_encode($user_regroup_array);
	}

	/*public function getCamshow(){
		$opts = array('http'=>array('timeout'=>3,));
		$context = stream_context_create($opts); 
        $fc_config = self::getConfig();
        $data = topcmmRequestRemote::requestRemote(CACHE_PATH."camshow.js",1);
		$camshow_json = substr($data,10);
	    if ((time() > substr($data,0,10)) || !$camshow_json){
	    	$data = '';
		    if($fc_config->fc_extendserver == 2){
				return false;
			}elseif($fc_config->fc_extendserver == 1){
				$data = topcmmRequestRemote::requestRemote($fc_config->fc_api_url."camshow.js?group=".$fc_config->fc_group,1);
			}else{
				$data = topcmmRequestRemote::requestRemote($fc_config->fc_api_url."camshow.js",1);
			}
			$camshow_json = substr($data,12,-1);
	        @file_put_contents(CACHE_PATH."camshow.js",(time() + 60) . $camshow_json);
	    }
	    $camshow_arr = json_decode($camshow_json);
	    if($camshow_arr){
	    	$random_num = rand(0, (count($camshow_arr)-1));
    		if(substr($camshow_arr[$random_num]->logo, 0,3) != '../' && substr($camshow_arr[$random_num]->logo, 0,7) != 'http://'){
	    		$camshow_arr[$random_num]->logo =  $fc_config->fc_api_url.$camshow_arr[$random_num]->logo;
	    	}else{
	    		$camshow_arr[$random_num]->logo = str_replace('../', $fc_config->fc_api_url, $camshow_arr[$random_num]->logo);
	    	}			
	    	return $camshow_arr[$random_num];
	    }else{
	    	return false;
	    }
		
	}*/
	
}
